/* -*- Mode:C; c-file-style:"gnu"; indent-tabs-mode:nil; -*- */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Marco Guastella <vasta@ragnu.it>
 */

/**
	*\file lupin.h
	*\author Marco Guastella(contact:vasta@ragnu.it)
	*\brief Main header file
*/

#ifndef	_LIBLUPIN_H
#define	_LIBLUPIN_H	1

#ifdef __cplusplus
extern "C" {
#endif

/**
	\defgroup version version library
*/

/**
	*\ingroup version 
	*\brief  major version
*/
	
#define LIBLUPIN_VERSION_MAJOR   0

/**
	*\ingroup version 
	*\brief  minor version
*/
	
#define LIBLUPIN_VERSION_MINOR   1

/**
	*\ingroup version 
	*\brief  sub version
*/

#define LIBLUPIN_VERSION_SUB       2

/**
	*\ingroup version 
	*\brief  release type
*/

#define LIBLUPIN_RELEASE "alpha"


#include "lupin-types.h"
#include "lupin-core.h"
#include "lupin-proto.h"

#ifdef __cplusplus
}
#endif
#endif /*end lupin.h*/

